//
//  WXKProgressWindowController.h
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/07/23.
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "WXKProgressing.h"

@interface WXKProgressWindowController : NSWindowController <WXKProgressing>
{
	IBOutlet NSProgressIndicator	*progressIndicator;
	IBOutlet NSTextField			*messageTextField;
	IBOutlet NSTextField			*countTextField;
	
	NSWindow		*parentWindow; // weak reference to parent window (not retain)
	
	@private
		NSModalSession	session;
		BOOL			isRequestedToAbort;
}

#pragma mark Class methods
+ (id)sharedWindowControllerWithParentWindow:(NSWindow *)window;

#pragma mark Initialization methods
- (id)initWithParentWindow:(NSWindow *)window;

#pragma mark Action methods
- (IBAction)requestToAbortProgress:(id)sender;

@end
